/*	Renegade Scripts.dll
	Example Plugin Code
	Copyright 2007 Whitedragon(MDB), Jonathan Wilson

	This file is part of the Renegade scripts.dll
	The Renegade scripts.dll is free software; you can redistribute it and/or modify it under
	the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2, or (at your option) any later
	version. See the file COPYING for more details.
	In addition, an exemption is given to allow Run Time Dynamic Linking of this code with any closed source module that does not contain code covered by this licence.
	Only the source code to the module(s) containing the licenced code has to be released.
*/

#include "gmsettingsclass.h"

#define PluginName "AFK Detector"
#define PluginVersion "1.0"

struct ExampleSettingsStruct : public virtual SettingsLoader {
	ExampleSettingsStruct(const char *ININame) : SettingsLoader(ININame) {
		wait_time = 99999;
		score_threshold = 99999;
	}

	void Load();

	int wait_time;
	int score_threshold;
	bool no_pointscheck_dead_pp, no_pointscheck_dead_ref, pm_afk_marked_player;
	std::string pm_marked_player_string;
};

void Plugin_Load();
void Plugin_Unload();

std::string Get_Closest_Building_Name(GameObject* obj);

class Iran_AFK_Detector : public ScriptImpClass {
	int poscount, scorecount, shotsfiredcount, facingcount;
	bool posunchanged, scoreunchanged, facingunchanged, shotsfiredunchanged;
	Vector3 oldpos, newpos;
	float oldscore, newscore;
	float oldfacing, newfacing;
	int oldshotsfired, newshotsfired;
	bool hasspoken, didvehicleaction, didpurchase;
	void Created(GameObject *obj);
	void Timer_Expired(GameObject *obj, int number);
	void Custom(GameObject *obj, int message, int param, GameObject *sender);
};

class Iran_AFK_Vehicle_Check : public ScriptImpClass {
	void Custom(GameObject *obj, int message, int param, GameObject *sender);
};

void Purchase_Monitor_Hook(BaseControllerClass *base, GameObject *purchaser, unsigned int cost, unsigned int preset,unsigned int purchaseret,const char *data);